import { useEffect, useState } from 'react'
import ServiceCard from '../components/ServiceCard'
import { mock } from '../api/mockApi'

export default function Services(){
  const [services, setServices] = useState([])
  useEffect(()=> setServices(mock.getServices()), [])
  return (
    <div className='max-w-6xl mx-auto px-4 py-10'>
      <h2 className='text-2xl font-bold mb-6'>All Services</h2>
      <div className='grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6'>
        {services.map(s=> <ServiceCard key={s.id} service={s} />)}
      </div>
    </div>
  )
}