import { useNavigate } from 'react-router-dom'
import { useAuth } from '../context/AuthContext'

export default function Register(){
  const { register } = useAuth()
  const nav = useNavigate()

  async function onSubmit(e){
    e.preventDefault()
    const f = new FormData(e.target)
    try {
      await register({ name: f.get('name'), email: f.get('email'), password: f.get('password') })
      nav('/')
    } catch(err) {
      alert(err.message)
    }
  }

  return (
    <div className='max-w-md mx-auto px-4 py-12'>
      <h2 className='text-2xl font-bold mb-4'>Create account</h2>
      <form onSubmit={onSubmit} className='space-y-3 bg-white p-6 rounded-xl shadow'>
        <input name='name' required className='w-full p-2 border rounded' placeholder='Full name' />
        <input name='email' type='email' required className='w-full p-2 border rounded' placeholder='Email' />
        <input name='password' type='password' required className='w-full p-2 border rounded' placeholder='Password' />
        <button className='w-full bg-green-600 text-white px-4 py-2 rounded'>Create account</button>
      </form>
    </div>
  )
}