import { useAuth } from '../context/AuthContext'
import { mock } from '../api/mockApi'

export default function MyBookings(){
  const { user } = useAuth()
  const bookings = user ? mock.getBookingsByUser(user.id) : []
  return (
    <div className='max-w-4xl mx-auto px-4 py-10'>
      <h2 className='text-2xl font-bold mb-4'>My Bookings</h2>
      <div className='space-y-4'>
        {bookings.length===0 && <div className='p-4 bg-white rounded shadow'>No bookings yet.</div>}
        {bookings.map(b=> (
          <div key={b.id} className='p-4 bg-white rounded shadow flex justify-between items-center'>
            <div>
              <div className='font-bold'>{b.serviceName}</div>
              <div className='text-sm text-slate-600'>{b.date} • {b.time}</div>
            </div>
            <div className='text-sm text-slate-500'>Booked by: {b.name}</div>
          </div>
        ))}
      </div>
    </div>
  )
}