import { motion } from 'framer-motion'
export default function Home(){
  return (
    <div className='max-w-6xl mx-auto px-4 py-12'>
      <motion.section initial={{opacity:0, y:10}} animate={{opacity:1, y:0}} className='grid grid-cols-1 lg:grid-cols-2 gap-8 items-center'>
        <div>
          <h1 className='text-4xl sm:text-5xl font-extrabold leading-tight'>Book appointments in seconds — Doctors, Salons & Spas</h1>
          <p className='mt-4 text-slate-600'>Responsive, fast and elegant booking system with admin dashboard and booking history.</p>
          <div className='mt-6 flex gap-3'>
            <a href='/services' className='px-4 py-2 rounded bg-gradient-to-r from-blue-400 to-blue-600 text-white'>Explore Services</a>
            <a href='/register' className='px-4 py-2 rounded border'>Get Started</a>
          </div>
        </div>
        <div className='p-6 card-glass rounded-xl shadow'>
          <div className='grid grid-cols-2 gap-4'>
            <div className='p-4 border rounded'>
              <div className='text-sm text-slate-500'>Next available</div>
              <div className='mt-2 font-semibold'>Tomorrow • 10:30 AM</div>
            </div>
            <div className='p-4 border rounded'>
              <div className='text-sm text-slate-500'>Top rated</div>
              <div className='mt-2 font-semibold'>Dr. Meera • 4.9</div>
            </div>
            <div className='p-4 border rounded'>
              <div className='text-sm text-slate-500'>Popular</div>
              <div className='mt-2 font-semibold'>Haircut</div>
            </div>
            <div className='p-4 border rounded'>
              <div className='text-sm text-slate-500'>Wellness</div>
              <div className='mt-2 font-semibold'>Spa</div>
            </div>
          </div>
        </div>
      </motion.section>
      <section className='mt-12'>
        <h2 className='text-2xl font-bold mb-4'>Featured Services</h2>
        <div className='grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6'>
          <div className='p-6 bg-white rounded-xl shadow'>Sample card — view Services page for full list.</div>
        </div>
      </section>
    </div>
  )
}