import { useParams, useNavigate } from 'react-router-dom'
import { mock } from '../api/mockApi'
import BookingForm from '../components/BookingForm'
import { useAuth } from '../context/AuthContext'

export default function BookAppointment(){
  const { serviceId } = useParams()
  const service = mock.getServices().find(s=>String(s.id)===serviceId)
  const nav = useNavigate()
  const { user } = useAuth()

  function handleSubmit(e){
    e.preventDefault()
    if(!user) return nav('/login')
    const f = new FormData(e.target)
    const booking = { serviceId: service.id, serviceName: service.name, userId: user.id, name: f.get('name'), date: f.get('date'), time: f.get('time') }
    mock.addBooking(booking)
    nav('/confirmation')
  }

  if(!service) return <div className='p-8'>Service not found</div>
  return (
    <div className='max-w-4xl mx-auto px-4 py-10'>
      <h2 className='text-2xl font-bold mb-4'>Book: {service.name}</h2>
      <BookingForm service={service} onSubmit={handleSubmit} />
    </div>
  )
}