import { useEffect, useState } from 'react'
import { mock } from '../api/mockApi'
import ServiceCard from '../components/ServiceCard'

export default function AdminPanel(){
  const [services, setServices] = useState([])
  const [editing, setEditing] = useState(null)
  useEffect(()=> setServices(mock.getServices()), [])

  function refresh(){ setServices(mock.getServices()) }
  function onAdd(){ setEditing({name:'', desc:'', price:0, image:'https://images.unsplash.com/photo-1522163182402-8b1b5d8b6c11?q=80&w=400&auto=format&fit=crop&ixlib=rb-4.0.3&s=4'}) }
  function onEdit(s){ setEditing({...s}) }
  function onDelete(id){ if(confirm('Delete service?')){ mock.deleteService(id); refresh() } }
  function onSave(e){
    e.preventDefault()
    const f=new FormData(e.target)
    const s={ id: editing.id, name: f.get('name'), desc: f.get('desc'), price: +f.get('price'), image: f.get('image') }
    if(s.id) mock.updateService(s); else mock.addService(s)
    setEditing(null); refresh()
  }

  return (
    <div className='max-w-6xl mx-auto px-4 py-10'>
      <div className='flex items-center justify-between mb-6'>
        <h2 className='text-2xl font-bold'>Admin Panel</h2>
        <button onClick={onAdd} className='px-4 py-2 bg-blue-600 text-white rounded'>Add Service</button>
      </div>
      <div className='grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-8'>
        {services.map(s=> <ServiceCard key={s.id} service={s} onEdit={onEdit} onDelete={onDelete} />)}
      </div>

      <h3 className='text-xl font-semibold mb-3'>All Bookings</h3>
      <div className='space-y-3'>
        {mock.getAllBookings().map(b=> (
          <div key={b.id} className='p-3 bg-white rounded shadow flex justify-between'>
            <div>
              <div className='font-bold'>{b.serviceName}</div>
              <div className='text-sm text-slate-600'>{b.date} • {b.time} — {b.name}</div>
            </div>
            <div className='text-sm text-slate-500'>User ID: {b.userId}</div>
          </div>
        ))}
      </div>

      {editing && (
        <div className='fixed inset-0 bg-black/40 flex items-center justify-center p-4'>
          <form onSubmit={onSave} className='w-full max-w-md bg-white p-6 rounded-xl'>
            <h4 className='font-bold mb-3'>{editing.id ? 'Edit service' : 'Add service'}</h4>
            <input name='name' defaultValue={editing.name} className='w-full p-2 border rounded mb-2' />
            <input name='desc' defaultValue={editing.desc} className='w-full p-2 border rounded mb-2' />
            <input name='price' defaultValue={editing.price} type='number' className='w-full p-2 border rounded mb-2' />
            <input name='image' defaultValue={editing.image} className='w-full p-2 border rounded mb-2' />
            <div className='flex justify-end gap-2'>
              <button type='button' onClick={()=>setEditing(null)} className='px-3 py-1 border rounded'>Cancel</button>
              <button className='px-3 py-1 bg-green-600 text-white rounded'>Save</button>
            </div>
          </form>
        </div>
      )}
    </div>
  )
}