import React, { createContext, useContext, useEffect, useState } from 'react'
import { mock } from '../api/mockApi'

const AuthContext = createContext()
export function useAuth(){ return useContext(AuthContext) }

export function AuthProvider({ children }){
  const [user, setUser] = useState(()=> JSON.parse(localStorage.getItem('bp_current')||'null'))
  useEffect(()=> { mock.init() }, [])

  function login(email, password){
    const u = mock.login(email, password)
    localStorage.setItem('bp_current', JSON.stringify(u))
    setUser(u)
    return u
  }
  function register(data){
    const u = mock.register(data)
    localStorage.setItem('bp_current', JSON.stringify(u))
    setUser(u)
    return u
  }
  function logout(){ localStorage.removeItem('bp_current'); setUser(null) }

  return <AuthContext.Provider value={{ user, login, register, logout }}>{children}</AuthContext.Provider>
}