import { motion } from 'framer-motion'
import { Link } from 'react-router-dom'

export default function ServiceCard({ service, onEdit, onDelete }){
  return (
    <motion.div layout initial={{opacity:0, y:10}} animate={{opacity:1, y:0}} className='card-glass rounded-xl shadow p-4'>
      <div className='h-44 w-full rounded-lg overflow-hidden mb-3'>
        <img src={service.image} alt={service.name} className='w-full h-full object-cover' />
      </div>
      <div className='flex justify-between items-start'>
        <div>
          <h3 className='text-lg font-semibold'>{service.name}</h3>
          <p className='text-sm text-slate-600'>{service.desc}</p>
        </div>
        <div className='text-right'>
          <div className='text-sm font-bold'>${service.price}</div>
        </div>
      </div>
      <div className='mt-3 flex gap-2'>
        <Link to={'/book/'+service.id} className='flex-1 text-center px-3 py-2 rounded bg-gradient-to-r from-blue-400 to-blue-600 text-white'>Book</Link>
        {onEdit && <button onClick={()=>onEdit(service)} className='px-3 py-2 border rounded'>Edit</button>}
        {onDelete && <button onClick={()=>onDelete(service.id)} className='px-3 py-2 border rounded text-red-600'>Delete</button>}
      </div>
    </motion.div>
  )
}