import { Navigate } from 'react-router-dom'
import { useAuth } from '../context/AuthContext'

export default function PrivateRoute({ children, adminOnly }) {
  const { user } = useAuth()
  if(!user) return <Navigate to='/login' replace />
  if(adminOnly && user.role!=='admin') return <Navigate to='/' replace />
  return children
}