import React from 'react'
import { Link, useNavigate } from 'react-router-dom'
import { useAuth } from '../context/AuthContext'

export default function Navbar(){
  const { user, logout } = useAuth()
  const nav = useNavigate()
  return (
    <nav className='bg-white/80 backdrop-blur sticky top-0 z-40 border-b'>
      <div className='max-w-6xl mx-auto px-4 py-3 flex items-center justify-between'>
        <div className='flex items-center gap-4'>
          <Link to='/' className='text-2xl font-extrabold bg-clip-text text-transparent' style={{background:'linear-gradient(90deg,#0ea5e9,#0284c7)'}}>BookingPro</Link>
          <Link to='/services' className='text-sm text-slate-600 hover:text-slate-800 hidden sm:inline'>Services</Link>
          {user && <Link to='/mybookings' className='text-sm text-slate-600 hover:text-slate-800 hidden sm:inline'>My Bookings</Link>}
        </div>
        <div className='flex items-center gap-3'>
          {user ? (
            <>
              <span className='text-sm text-slate-700 hidden md:inline'>Hi, {user.name}</span>
              {user.role==='admin' && <Link to='/admin' className='px-3 py-1 border rounded text-sm'>Admin</Link>}
              <button onClick={()=>{ logout(); nav('/') }} className='px-3 py-1 bg-red-500 text-white rounded text-sm'>Logout</button>
            </>
          ) : (
            <>
              <Link to='/login' className='px-3 py-1 bg-blue-600 text-white rounded text-sm'>Login</Link>
              <Link to='/register' className='px-3 py-1 border rounded text-sm hidden sm:inline'>Register</Link>
            </>
          )}
        </div>
      </div>
    </nav>
  )
}