export default function BookingForm({ service, onSubmit }) {
  return (
    <form
      onSubmit={onSubmit}
      className="max-w-xl mx-auto bg-white p-6 rounded-xl shadow space-y-3"
    >
      <div>
        <label className="text-sm font-medium block mb-1">Service</label>
        <input
          readOnly
          value={service.name}
          className="w-full p-2 border rounded bg-slate-50"
        />
      </div>
      <div>
        <label className="text-sm font-medium block mb-1">Full name</label>
        <input
          name="name"
          required
          className="w-full p-2 border rounded"
          placeholder="Your full name"
        />
      </div>
      <div className="grid grid-cols-1 sm:grid-cols-2 gap-3">
        <div>
          <label className="text-sm font-medium block mb-1">Date</label>
          <input
            name="date"
            required
            type="date"
            className="w-full p-2 border rounded"
          />
        </div>
        <div>
          <label className="text-sm font-medium block mb-1">Time</label>
          <input
            name="time"
            required
            type="time"
            className="w-full p-2 border rounded"
          />
        </div>
      </div>
      <button className="w-full bg-green-600 text-white px-4 py-2 rounded">
        Confirm Booking
      </button>
    </form>
  );
}
