export const mock = {
  init() {
    if (!localStorage.getItem('bp_users')) {
      const users = [{ id: 1, name: 'Admin', email: 'admin@bookingpro.com', password: 'admin', role: 'admin' }];
      localStorage.setItem('bp_users', JSON.stringify(users));
    }
    if (!localStorage.getItem('bp_services')) {
      const services = [
        { id: 1, name: 'Doctor Consultation', desc: 'Experienced general physician', price: 50, image: 'https://images.unsplash.com/photo-1580281657521-3a3f3b6e0b35?q=80&w=400&auto=format&fit=crop&ixlib=rb-4.0.3&s=1' },
        { id: 2, name: 'Salon Haircut', desc: 'Modern cuts & styling', price: 25, image: 'https://images.unsplash.com/photo-1544005313-94ddf0286df2?q=80&w=400&auto=format&fit=crop&ixlib=rb-4.0.3&s=2' },
        { id: 3, name: 'Relaxing Spa', desc: 'Therapeutic massages & spa', price: 70, image: 'https://images.unsplash.com/photo-1556228720-0e4f1f3b6a3c?q=80&w=400&auto=format&fit=crop&ixlib=rb-4.0.3&s=3' }
      ];
      localStorage.setItem('bp_services', JSON.stringify(services));
    }
    if (!localStorage.getItem('bp_bookings')) localStorage.setItem('bp_bookings', JSON.stringify([]));
  },
  // Auth
  register(user) {
    const users = JSON.parse(localStorage.getItem('bp_users')||'[]');
    if (users.find(u=>u.email===user.email)) throw new Error('Email already used');
    user.id = Date.now(); user.role = 'user';
    users.push(user);
    localStorage.setItem('bp_users', JSON.stringify(users));
    return user;
  },
  login(email, password){
    const users = JSON.parse(localStorage.getItem('bp_users')||'[]');
    const u = users.find(x=>x.email===email && x.password===password);
    if(!u) throw new Error('Invalid credentials');
    return u;
  },
  // services
  getServices(){ return JSON.parse(localStorage.getItem('bp_services')||'[]'); },
  addService(s){ const arr=this.getServices(); s.id=Date.now(); arr.push(s); localStorage.setItem('bp_services', JSON.stringify(arr)); return s; },
  updateService(s){ const arr=this.getServices(); const idx=arr.findIndex(x=>x.id===s.id); if(idx===-1) throw new Error('Not found'); arr[idx]=s; localStorage.setItem('bp_services', JSON.stringify(arr)); return s; },
  deleteService(id){ let arr=this.getServices(); arr=arr.filter(x=>x.id!==id); localStorage.setItem('bp_services', JSON.stringify(arr)); },
  // bookings
  addBooking(b){ const arr=JSON.parse(localStorage.getItem('bp_bookings')||'[]'); b.id=Date.now(); arr.push(b); localStorage.setItem('bp_bookings', JSON.stringify(arr)); return b; },
  getBookingsByUser(userId){ return JSON.parse(localStorage.getItem('bp_bookings')||'[]').filter(b=>b.userId===userId); },
  getAllBookings(){ return JSON.parse(localStorage.getItem('bp_bookings')||'[]'); }
};