import React from 'react'
import { BrowserRouter, Routes, Route } from 'react-router-dom'
import { AuthProvider } from './context/AuthContext'
import Navbar from './components/Navbar'
import Footer from './components/Footer'
import Home from './pages/Home'
import Services from './pages/Services'
import BookAppointment from './pages/BookAppointment'
import Confirmation from './pages/Confirmation'
import Login from './pages/Login'
import Register from './pages/Register'
import MyBookings from './pages/MyBookings'
import AdminPanel from './pages/AdminPanel'
import PrivateRoute from './components/PrivateRoute'

export default function App(){
  return (
    <AuthProvider>
      <BrowserRouter>
        <div className='min-h-screen flex flex-col'>
          <Navbar />
          <main className='flex-grow'>
            <Routes>
              <Route path='/' element={<Home />} />
              <Route path='/services' element={<Services />} />
              <Route path='/book/:serviceId' element={<BookAppointment />} />
              <Route path='/confirmation' element={<Confirmation />} />
              <Route path='/login' element={<Login />} />
              <Route path='/register' element={<Register />} />
              <Route path='/mybookings' element={<PrivateRoute><MyBookings /></PrivateRoute>} />
              <Route path='/admin' element={<PrivateRoute adminOnly={true}><AdminPanel /></PrivateRoute>} />
            </Routes>
          </main>
          <Footer />
        </div>
      </BrowserRouter>
    </AuthProvider>
  )
}