import express from 'express';
import { createTask, getTasks, updateTask } from '../controllers/taskController.js';
import { protect } from '../middleware/authMiddleware.js';

const router = express.Router();

router.route('/')
    .post(protect, createTask);

router.route('/project/:projectId')
    .get(protect, getTasks);

router.route('/:id')
    .put(protect, updateTask);

export default router;
