import mongoose from 'mongoose';

const projectSchema = new mongoose.Schema({
    name: { type: String, required: true },
    description: { type: String },
    deadline: { type: Date },
    createdBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User', required: true },
    members: [{ type: mongoose.Schema.Types.ObjectId, ref: 'User' }],
    status: { type: String, enum: ['Pending', 'Active', 'Completed', 'Archived'], default: 'Pending' },
}, { timestamps: true });

const Project = mongoose.model('Project', projectSchema);
export default Project;
