import User from '../models/User.js';

// @desc    Get all users
// @route   GET /api/users
// @access  Private (Admin/Manager primarily, but useful for selection)
const getUsers = async (req, res) => {
    try {
        const users = await User.find({}).select('-password');
        res.json(users);
    } catch (error) {
        res.status(500).json({ message: 'Server Error' });
    }
};

export { getUsers };
