import React from 'react'

export default function WeatherCard({ data }) {
  const { city, temp, condition, description, humidity, wind } = data
  return (
    <div className="backdrop-blur-md bg-white/10 rounded-3xl shadow-xl p-8 w-full max-w-2xl">
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-3xl font-bold">{city}</h2>
          <p className="text-sm opacity-80">{description} • {condition}</p>
        </div>
        <div className="text-right">
          <div className="text-6xl font-extrabold">{temp}°C</div>
          <div className="text-sm opacity-80">Feels like {temp + (condition==='Clear' ? 1 : 0)}°</div>
        </div>
      </div>

      <div className="mt-6 grid grid-cols-3 gap-4 text-sm">
        <div className="p-3 rounded-xl bg-white/5 text-center">
          <div className="font-semibold">{humidity}%</div>
          <div className="opacity-80">Humidity</div>
        </div>
        <div className="p-3 rounded-xl bg-white/5 text-center">
          <div className="font-semibold">{wind} km/h</div>
          <div className="opacity-80">Wind</div>
        </div>
        <div className="p-3 rounded-xl bg-white/5 text-center">
          <div className="font-semibold">{condition}</div>
          <div className="opacity-80">Condition</div>
        </div>
      </div>

      <div className="mt-6 flex items-center justify-between">
        <div className="text-xs opacity-80">Last updated: <span className="font-medium">just now</span></div>
        <div className="text-xs opacity-80">Data: sample/static</div>
      </div>
    </div>
  )
}
