import React from 'react'

export default function CitySelector({ cities, value, onChange }) {
  return (
    <div className="w-full max-w-md">
      <label className="block text-sm font-medium mb-2">Choose city</label>
      <select
        value={value}
        onChange={(e) => onChange(e.target.value)}
        className="w-full p-3 rounded-xl bg-white/10 focus:outline-none focus:ring-2 focus:ring-white/30"
      >
        {cities.map(c => (
          <option key={c.id} value={c.id}>
            {c.city}
          </option>
        ))}
      </select>
    </div>
  )
}
