import React from 'react'
import clsx from 'clsx'

const gradients = {
  Clear: 'from-yellow-400 via-orange-400 to-pink-400',
  Clouds: 'from-slate-500 via-slate-600 to-slate-700',
  Rain: 'from-blue-700 via-indigo-700 to-slate-800',
  Snow: 'from-teal-100 via-blue-100 to-indigo-100',
  Mist: 'from-slate-400 via-slate-500 to-slate-600',
  Default: 'from-indigo-500 via-purple-500 to-pink-500'
}

export default function BackgroundGradient({ condition, children }) {
  const g = gradients[condition] || gradients.Default
  const classNames = clsx('min-h-screen flex items-center justify-center bg-gradient-to-br bg-transition', g)
  return <div className={classNames}>{children}</div>
}
