import React, { useState, useMemo } from 'react'
import BackgroundGradient from './components/BackgroundGradient'
import CitySelector from './components/CitySelector'
import WeatherCard from './components/WeatherCard'
import { SAMPLE_WEATHER } from './data/sampleWeather'

export default function App(){
  const [cityId, setCityId] = useState(SAMPLE_WEATHER[0].id)

  const current = useMemo(() => SAMPLE_WEATHER.find(s => s.id === cityId) || SAMPLE_WEATHER[0], [cityId])

  return (
    <BackgroundGradient condition={current.condition}>
      <div className="container mx-auto px-6 py-16">
        <div className="flex flex-col lg:flex-row gap-8 items-start">
          <div className="flex-1">
            <CitySelector cities={SAMPLE_WEATHER} value={cityId} onChange={setCityId} />
            <div className="mt-6">
              <WeatherCard data={current} />
            </div>
          </div>

          <aside className="w-full lg:w-96">
            <div className="p-6 rounded-2xl bg-white/5 backdrop-blur-md">
              <h3 className="text-lg font-semibold mb-3">Quick tips</h3>
              <ul className="text-sm opacity-90 space-y-2">
                <li>• Backgrounds change by condition (try Clear, Rain, Snow, Clouds)</li>
                <li>• This demo uses static sample data — swap with real API easily</li>
                <li>• Responsive + accessible selects and cards</li>
              </ul>
            </div>

            <div className="mt-6 p-6 rounded-2xl bg-white/5">
              <h4 className="font-medium mb-2">Other samples</h4>
              <div className="grid grid-cols-2 gap-3">
                {SAMPLE_WEATHER.map(s => (
                  <button
                    key={s.id}
                    onClick={() => setCityId(s.id)}
                    className="p-3 rounded-xl bg-white/6 text-sm hover:scale-105 transition-transform"
                  >
                    {s.city}
                    <div className="text-xs opacity-80">{s.temp}°</div>
                  </button>
                ))}
              </div>
            </div>
          </aside>
        </div>

        <footer className="mt-10 text-center text-xs opacity-80">
          Built with ❤️ using React, Vite & Tailwind — static demo
        </footer>
      </div>
    </BackgroundGradient>
  )
}
