import React from "react";
import { BrowserRouter, Route, Routes } from "react-router-dom";
import StudentList from "./pages/StudentList";
import AddStudent from "./pages/AddStudent";
import EditStudent from "./pages/EditStudent";
import StudentView from "./pages/StudentView";

export const App = () => {
  return (
    <>
      <BrowserRouter>
        <Routes>
          <Route path="/" element = {<StudentList />}/>
          <Route path="/view/:id" element = {<StudentView />}/>
          <Route path="/add" element = {<AddStudent />}/>
          <Route path="/edit/:id" element = {<EditStudent />}/>
        </Routes>
      </BrowserRouter>
    </>
  );
};
