var express = require('express');
var dotenv = require('dotenv');
var cors = require('cors');
var connectDB = require('./config/db');
var path = require('path');


dotenv.config();
connectDB();

const app = express();
app.use(cors());
app.use(express.json());

// Image Path
app.use('/uploads', express.static(path.join(process.cwd(), "uploads")));

// routes
app.use('/api/students', require('./routes/studentRoutes'));

//  Server
app.listen(process.env.PORT, () => {
    console.log('Server is running on port', process.env.PORT)
});