var express = require("express");
const Student = require("../models/Student");
const {
  getStudents,
  getStudentById,
  addStudent,
  updateStudent,
  deleteStudent,
} = require("../controllers/studentController");
const upload = require("../middleware/uploadMiddleware");
var router = express.Router();

router.get("/", getStudents);

router.post("/", upload.single("image"), addStudent);

router.get("/:id", getStudentById);

router.put("/:id", upload.single("image"), updateStudent);

router.delete("/:id", deleteStudent);

module.exports = router;
