const Student = require("../models/Student");

exports.getStudents = async (req, res) => {
  try {
    const students = await Student.find();
    res.json(students);
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "Error fetching students" });
  }
};

exports.getStudentById = async (req, res) => {
  try {
    const student = await Student.findById(req.params.id);
    res.json(student);
  } catch (err) {
    res.status(404).json("Student Not Found", err);
  }
};

exports.addStudent = async (req, res) => {
  try {
    const { name, email, course } = req.body;
    const image = req.file ? `/uploads/${req.file.filename}` : "";
    const student = new Student({ name, email, course, image });
    await student.save();
    res.json(student);
  } catch (err) {
    res.status(500).json("Failed To Create Student", err);
  }
};

exports.updateStudent = async (req, res) => {
  try {
    const { name, email, course } = req.body;
    const image = req.file ? `/uploads/${req.file.filename}` : "";
    const updated = await Student.findByIdAndUpdate(
      req.params.id,
      { name, email, course, image },
      { new: true }
    );
    res.json(updated);
  } catch (err) {
    res.status(500).json("Failed To Update Student", err);
  }
};

exports.deleteStudent = async (req, res) => {
  try {
    const deleted = await Student.findByIdAndDelete(req.params.id);
    res.json(deleted);
  } catch (err) {
    res.status(500).json("Failed To Delete Student", err);
  }
};
