const nodemailer = require('nodemailer');

const transporter = nodemailer.createTransport({
  host: process.env.SMTP_HOST,
  port: Number(process.env.SMTP_PORT || 587),
  secure: false,
  auth: {
    user: process.env.SMTP_USER,
    pass: process.env.SMTP_PASS,
  },
});

async function sendOtpEmail(to, otp) {
  const info = await transporter.sendMail({
    from: process.env.FROM_EMAIL,
    to,
    subject: 'Your verification OTP',
    text: `Your OTP is ${otp}. It will expire in ${process.env.OTP_EXPIRE_SECONDS || 30} seconds.`,
    html: `<p>Your OTP is <b>${otp}</b>. It will expire in <b>${process.env.OTP_EXPIRE_SECONDS || 30}</b> seconds.</p>`
  });
  return info;
}

module.exports = { sendOtpEmail };
