import React from 'react'
import ImageCompressor from './components/ImageCompressor'

export default function App(){
  return (
    <div className="min-h-screen bg-gradient-to-b from-slate-900 to-slate-800 text-slate-100 p-6">
      <div className="max-w-4xl mx-auto bg-slate-900/60 backdrop-blur rounded-2xl shadow-xl p-6">
        <header className="mb-6">
          <h1 className="text-2xl sm:text-3xl font-bold">Image KB Converter</h1>
          <p className="text-slate-300 mt-1">Upload images and convert/compress them to a target file size (KB) in the browser.</p>
        </header>
        <ImageCompressor />
        <footer className="text-xs text-slate-400 mt-6">
          Built with React + Vite + Tailwind • Client-side compression (no upload)
        </footer>
      </div>
    </div>
  )
}
