# Image KB Converter (React + Vite + Tailwind)

Client-side image compressor that tries to convert images to a target file size (KB).

## Features
- React + Vite starter
- Tailwind CSS for modern responsive UI
- Client-side compression using canvas and quality/dimension adjustments
- Preview & download compressed image
- No server — everything runs in the browser

## Setup
1. Install dependencies:
   ```bash
   npm install
   ```
2. Start dev server:
   ```bash
   npm run dev
   ```
3. Open the app (usually at http://localhost:5173)

## Notes & Tips
- Browser compression results vary by image content and format.
- PNG with alpha channels are converted to JPEG for better compression (loses transparency).
- If the compressor cannot reach the requested size without extreme quality loss, it will scale dimensions down.

## File structure
- `src/components/ImageCompressor.jsx` — main logic & UI
- `src/App.jsx`, `src/main.jsx` — entry
- `tailwind.config.cjs`, `postcss.config.cjs` — Tailwind config

Enjoy! 🎉
