import React, { useState } from 'react'

const unicodeDice = ['⚀','⚁','⚂','⚃','⚄','⚅']

function DieFace({value, animKey}) {
  // show Unicode die face as big character
  return (
    <div className={"die " + (animKey ? 'spin' : '')} aria-hidden>
      <span>{unicodeDice[value-1]}</span>
    </div>
  )
}

export default function Dice(){
  const [count, setCount] = useState(1)
  const [values, setValues] = useState([1])
  const [anim, setAnim] = useState(false)

  function roll(){
    // animate then set numbers
    setAnim(true)
    const newVals = Array.from({length: count}, ()=> Math.floor(Math.random()*6)+1)
    // small timeout to allow css animation
    setTimeout(()=>{
      setValues(newVals)
      setAnim(false)
    }, 900)
  }

  return (
    <div className="w-full flex flex-col items-center gap-4">
      <h2 className="text-lg font-semibold">{count} Dice</h2>

      <div className="flex gap-3 flex-wrap justify-center">
        {values.map((v,i)=>(
          <DieFace key={i} value={v} animKey={anim} />
        ))}
      </div>

      <div className="w-full flex flex-col sm:flex-row gap-3 items-center justify-center mt-4">
        <label className="flex items-center gap-2">
          <span className="text-sm">Number of dice</span>
          <select
            value={count}
            onChange={(e)=> {
              const n = Math.max(1, Math.min(6, Number(e.target.value)))
              setCount(n)
              setValues(Array.from({length:n}, ()=>1))
            }}
            className="ml-2 px-3 py-2 rounded-lg border"
            aria-label="Number of dice"
          >
            {[1,2,3,4,5,6].map(n=> <option key={n} value={n}>{n}</option>)}
          </select>
        </label>

        <button
          onClick={roll}
          className="ml-0 sm:ml-2 px-4 py-2 rounded-lg bg-indigo-600 text-white font-semibold shadow hover:bg-indigo-700"
        >
          Roll
        </button>

        <button
          onClick={()=> { setValues(Array.from({length:count}, ()=>1)) }}
          className="px-4 py-2 rounded-lg border"
        >
          Reset
        </button>
      </div>

      <div className="mt-4 text-sm text-slate-700">
        <strong>Result:</strong> {values.join(' , ')}
      </div>
    </div>
  )
}
