import React, { useState } from 'react'

export default function Coin(){
  const [result, setResult] = useState(null)
  const [spinning, setSpinning] = useState(false)

  function toss(){
    setSpinning(true)
    // simple random toss
    const r = Math.random() < 0.5 ? 'Heads' : 'Tails'
    setTimeout(()=>{
      setResult(r)
      setSpinning(false)
    }, 900)
  }

  return (
    <div className="w-full flex flex-col items-center gap-4">
      <h2 className="text-lg font-semibold">Coin Toss</h2>

      <div className="flex flex-col items-center gap-3">
        <div className={"coin " + (spinning ? 'spin' : '')} aria-hidden>
          <div className="transform">
            <span className="block text-center">{result ?? 'Flip'}</span>
          </div>
        </div>

        <div className="flex gap-3">
          <button
            onClick={toss}
            className="px-4 py-2 rounded-lg bg-indigo-600 text-white font-semibold shadow hover:bg-indigo-700"
          >
            Toss
          </button>
          <button
            onClick={()=> setResult(null)}
            className="px-4 py-2 rounded-lg border"
          >
            Reset
          </button>
        </div>

        <div className="mt-2 text-sm text-slate-700">
          <strong>Outcome:</strong> {result ?? '—'}
        </div>
      </div>
    </div>
  )
}
