import React, { useState } from "react";
import Dice from "./components/Dice";
import Coin from "./components/Coin";

export default function App() {
  const [mode, setMode] = useState("dice"); // 'dice' or 'coin'

  return (
    <div className="min-h-screen flex items-center justify-center p-6">
      <div className="container mx-auto bg-white/60 backdrop-blur-md rounded-3xl shadow-xl p-6 sm:p-10">
        <header className="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
          <div>
            <h1 className="text-2xl sm:text-3xl font-bold">
              🎲 Dice & 🪙 Coin — Playground
            </h1>
            <p className="text-sm text-slate-600 mt-1">
              No API — fully local, responsive, and accessible.
            </p>
          </div>

          <div className="flex items-center gap-3 bg-slate-50 p-2 rounded-lg">
            <button
              onClick={() => setMode("dice")}
              className={`px-3 py-2 rounded-lg font-medium ${
                mode === "dice" ? "bg-indigo-600 text-white" : "text-slate-700"
              }`}
            >
              Dice Roller
            </button>
            <button
              onClick={() => setMode("coin")}
              className={`px-3 py-2 rounded-lg font-medium ${
                mode === "coin" ? "bg-indigo-600 text-white" : "text-slate-700"
              }`}
            >
              Coin Toss
            </button>
          </div>
        </header>

        <main className="mt-8 grid grid-cols-1 md:grid-cols-2 gap-6 items-start">
          <section className="flex flex-col items-center gap-4 p-4">
            {mode === "dice" ? <Dice /> : <Coin />}
          </section>

          <aside className="p-4 bg-slate-50 rounded-xl">
            <h3 className="font-semibold mb-2">How to use</h3>
            <ol className="list-decimal list-inside text-sm space-y-2 text-slate-700">
              <li>Choose mode (Dice or Coin) using the top buttons.</li>
              <li>For Dice: pick number of dice (1–6), press Roll.</li>
              <li>
                For Coin: press Toss — coin will flip and show Heads or Tails.
              </li>
              <li>Results are shown and preserved until next roll/toss.</li>
            </ol>

            <div className="mt-4">
              <h4 className="font-semibold">Accessibility</h4>
              <p className="text-sm text-slate-700 mt-1">
                Controls are usable by keyboard and have clear labels.
              </p>
            </div>

            <div className="mt-4">
              <h4 className="font-semibold">Save / Share</h4>
              <p className="text-sm text-slate-700 mt-1">
                This is offline-only. You can extend with LocalStorage if you
                like.
              </p>
            </div>
          </aside>
        </main>

        <footer className="mt-6 text-center text-xs text-slate-500">
          Built with Vite, React & Tailwind — no external APIs.
        </footer>
      </div>
    </div>
  );
}
