import React, { useState } from "react";
import API from "../api";
import { toast } from "react-toastify";

export default function Contact() {
  const [form, setForm] = useState({
    name: "",
    email: "",
    subject: "",
    message: "",
  });
  const [loading, setLoading] = useState(false);

  const handleChange = (e) =>
    setForm({ ...form, [e.target.name]: e.target.value });

  const handleSubmit = async (e) => {
    e.preventDefault();
    setLoading(true);
    try {
      await API.post("/inquiries", form);
      toast.success("Message sent successfully!");
      setForm({ name: "", email: "", subject: "", message: "" });
    } catch (err) {
      console.error(err);
      toast.error(err?.response?.data?.message || "Failed to send message!");
    } finally {
      setLoading(false);
    }
  };

  return (
    <section className="flex justify-center items-center min-h-[80vh] px-4">
      <div className="w-full max-w-lg bg-white/70 backdrop-blur-md border border-gray-200 shadow-lg rounded-2xl p-8 transition-all duration-300 hover:shadow-2xl">
        <h2 className="text-2xl font-semibold text-gray-800 mb-6 text-center">
          Get in Touch
        </h2>
        <form onSubmit={handleSubmit} className="space-y-5">
          {/* Name */}
          <div className="relative">
            <input
              type="text"
              name="name"
              value={form.name}
              onChange={handleChange}
              required
              className="peer w-full p-3 border border-gray-300 rounded-lg bg-transparent placeholder-transparent focus:outline-none focus:border-indigo-500"
              placeholder="Your name"
            />
            <label className="absolute left-3 top-3 text-gray-500 text-sm transition-all peer-placeholder-shown:top-3.5 peer-placeholder-shown:text-gray-400 peer-placeholder-shown:text-base peer-focus:top-1 peer-focus:text-xs peer-focus:text-indigo-500">
              Your Name
            </label>
          </div>

          {/* Email */}
          <div className="relative">
            <input
              type="email"
              name="email"
              value={form.email}
              onChange={handleChange}
              required
              className="peer w-full p-3 border border-gray-300 rounded-lg bg-transparent placeholder-transparent focus:outline-none focus:border-indigo-500"
              placeholder="Your email"
            />
            <label className="absolute left-3 top-3 text-gray-500 text-sm transition-all peer-placeholder-shown:top-3.5 peer-placeholder-shown:text-gray-400 peer-placeholder-shown:text-base peer-focus:top-1 peer-focus:text-xs peer-focus:text-indigo-500">
              Email Address
            </label>
          </div>

          {/* Subject */}
          <div className="relative">
            <input
              type="text"
              name="subject"
              value={form.subject}
              onChange={handleChange}
              required
              className="peer w-full p-3 border border-gray-300 rounded-lg bg-transparent placeholder-transparent focus:outline-none focus:border-indigo-500"
              placeholder="Subject"
            />
            <label className="absolute left-3 top-3 text-gray-500 text-sm transition-all peer-placeholder-shown:top-3.5 peer-placeholder-shown:text-gray-400 peer-placeholder-shown:text-base peer-focus:top-1 peer-focus:text-xs peer-focus:text-indigo-500">
              Subject
            </label>
          </div>

          {/* Message */}
          <div className="relative">
            <textarea
              name="message"
              value={form.message}
              onChange={handleChange}
              rows="5"
              required
              className="peer w-full p-3 border border-gray-300 rounded-lg bg-transparent placeholder-transparent focus:outline-none focus:border-indigo-500 resize-none"
              placeholder="Your message"
            ></textarea>
            <label className="absolute left-3 top-3 text-gray-500 text-sm transition-all peer-placeholder-shown:top-3.5 peer-placeholder-shown:text-gray-400 peer-placeholder-shown:text-base peer-focus:top-1 peer-focus:text-xs peer-focus:text-indigo-500">
              Message
            </label>
          </div>

          {/* Submit */}
          <button
            type="submit"
            disabled={loading}
            className={`w-full py-3 rounded-lg font-medium text-white transition-all ${
              loading
                ? "bg-gray-400 cursor-not-allowed"
                : "bg-gradient-to-r from-indigo-600 to-purple-600 hover:opacity-90"
            }`}
          >
            {loading ? "Sending..." : "Send Message"}
          </button>
        </form>
      </div>
    </section>
  );
}
