import React, { useEffect, useState } from 'react';
import API from '../api';
import { toast } from 'react-toastify';
import { useNavigate } from 'react-router-dom';

export default function Admin(){
  const [list, setList] = useState([]);
  const navigate = useNavigate();

  const token = localStorage.getItem('token');
  useEffect(() => {
    if (!token) { navigate('/login'); return; }
    fetchList();
  }, []);

  const fetchList = async () => {
    try {
      const { data } = await API.get('/inquiries', { headers: { Authorization: `Bearer ${token}` } });
      setList(data);
    } catch (err) {
      console.error(err);
      toast.error('Failed to load or unauthorized');
      if (err.response?.status === 401) navigate('/login');
    }
  };

  const handleDelete = async id => {
    if (!confirm('Delete this inquiry?')) return;
    try {
      await API.delete(`/inquiries/${id}`, { headers: { Authorization: `Bearer ${token}` } });
      toast.success('Deleted');
      setList(list.filter(i => i._id !== id));
    } catch (err) {
      console.error(err);
      toast.error('Delete failed');
    }
  };

  return (
    <div>
      <h2 className="text-xl font-semibold mb-4">Admin - Inquiries</h2>
      <div className="space-y-3">
        {list.length === 0 && <div className="p-4 bg-white rounded shadow">No inquiries</div>}
        {list.map(i => (
          <div key={i._id} className="bg-white p-4 rounded shadow flex justify-between items-start">
            <div>
              <div className="font-semibold">{i.name} <span className="text-sm text-gray-500">({i.email})</span></div>
              <div className="text-sm text-gray-600">{i.subject}</div>
              <p className="mt-2">{i.message}</p>
              <div className="text-xs text-gray-400 mt-1">{new Date(i.createdAt).toLocaleString()}</div>
            </div>
            <div className="flex flex-col gap-2">
              <button onClick={() => handleDelete(i._id)} className="px-5 py-1 text-[14px] bg-red-100 hover:bg-red-500 rounded-full text-red-500 hover:text-white">Delete</button>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
}
