import React, { useState } from "react";
import { BrowserRouter, Routes, Route, NavLink, Link } from "react-router-dom";
import Contact from "./pages/Contact";
import Login from "./pages/Login";
import Admin from "./pages/Admin";
import { ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

export default function App() {
  const [menuOpen, setMenuOpen] = useState(false);
  const token = localStorage.getItem("token");
  const role = localStorage.getItem("role");
  const isLoggedIn = token && role;

  return (
    <BrowserRouter>
      <div className="min-h-screen bg-gray-50 flex flex-col">
        {/* Navbar */}
        <nav className="bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-500 shadow-md">
          <div className="container mx-auto flex justify-between items-center px-6 py-4">
            {/* Logo */}
            <Link
              to="/"
              className="text-white font-bold text-xl tracking-wide hover:opacity-90 transition"
            >
              Contact<span className="text-yellow-300">Form</span>
            </Link>

            {/* Desktop Menu */}
            <div className="hidden md:flex gap-6 text-white">
              <NavLink
                to="/"
                className={({ isActive }) =>
                  `hover:text-yellow-300 transition ${
                    isActive ? "text-yellow-300 font-semibold" : ""
                  }`
                }
              >
                Contact
              </NavLink>
              <NavLink
                to="/admin"
                className={({ isActive }) =>
                  `hover:text-yellow-300 transition ${
                    isActive ? "text-yellow-300 font-semibold" : ""
                  }`
                }
              >
                Admin
              </NavLink>
              {!isLoggedIn && (
                <NavLink
                  to="/login"
                  className={({ isActive }) =>
                    `hover:text-yellow-300 transition ${
                      isActive ? "text-yellow-300 font-semibold" : ""
                    }`
                  }
                >
                  Login
                </NavLink>
              )}
            </div>

            {/* Mobile Menu Toggle */}
            <button
              className="md:hidden text-white focus:outline-none"
              onClick={() => setMenuOpen(!menuOpen)}
            >
              {menuOpen ? (
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M6 18L18 6M6 6l12 12"
                  />
                </svg>
              ) : (
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M4 6h16M4 12h16M4 18h16"
                  />
                </svg>
              )}
            </button>
          </div>

          {/* Mobile Menu */}
          {menuOpen && (
            <div className="md:hidden bg-white text-gray-800 flex flex-col gap-3 px-6 py-3">
              <NavLink
                to="/"
                className={({ isActive }) =>
                  `hover:text-indigo-600 transition ${
                    isActive ? "text-indigo-600 font-semibold" : ""
                  }`
                }
                onClick={() => setMenuOpen(false)}
              >
                Contact
              </NavLink>
              <NavLink
                to="/admin"
                className={({ isActive }) =>
                  `hover:text-indigo-600 transition ${
                    isActive ? "text-indigo-600 font-semibold" : ""
                  }`
                }
                onClick={() => setMenuOpen(false)}
              >
                Admin
              </NavLink>
              {!isLoggedIn && (
                <NavLink
                  to="/login"
                  className={({ isActive }) =>
                    `hover:text-indigo-600 transition ${
                      isActive ? "text-indigo-600 font-semibold" : ""
                    }`
                  }
                  onClick={() => setMenuOpen(false)}
                >
                  Login
                </NavLink>
              )}
            </div>
          )}
        </nav>

        {/* Main Content */}
        <main className="container mx-auto p-6 flex-grow">
          <Routes>
            <Route path="/" element={<Contact />} />
            <Route path="/login" element={<Login />} />
            <Route path="/admin" element={<Admin />} />
          </Routes>
        </main>
      </div>

      {/* Toastify Container */}
      <ToastContainer position="top-right" />
    </BrowserRouter>
  );
}
