import React, { useState } from "react";
import API from "../api";
import { useNavigate, Link } from "react-router-dom";
import { toast } from "react-toastify";

export default function Register() {
  const [form, setForm] = useState({ name: "", email: "", password: "" });
  const [loading, setLoading] = useState(false);
  const nav = useNavigate();

  const handle = async (e) => {
    e.preventDefault();
    setLoading(true);
    try {
      await API.post("/auth/register", form);
      window.dispatchEvent(new Event("userUpdated"));
      toast.success("Registration successfully!");

      nav("/login");
    } catch (err) {
      toast.error(err.response?.data?.message || "Registration failed");
    } finally {
      setLoading(false);
    }
  };

  return (
    <main className="min-h-[70vh] flex items-center justify-center px-4 py-12">
      <div className="max-w-4xl w-full grid grid-cols-1 md:grid-cols-2 gap-8">
        <div className="bg-gray-900 rounded-xl p-8 shadow">
          <h2 className="text-xl font-semibold text-white mb-4">Create your account</h2>
          <form onSubmit={handle} className="space-y-4">
            <input
              required
              placeholder="Full name"
              value={form.name}
              onChange={(e) => setForm({ ...form, name: e.target.value })}
              className="w-full bg-gray-800 border text-white focus:outline-0 focus:border-amber-300 border-gray-700 rounded-md px-4 py-3"
            />
            <input
              required
              type="email"
              placeholder="Email"
              value={form.email}
              onChange={(e) => setForm({ ...form, email: e.target.value })}
              className="w-full bg-gray-800 border text-white focus:outline-0 focus:border-amber-300 border-gray-700 rounded-md px-4 py-3"
            />
            <input
              required
              type="password"
              placeholder="Password"
              value={form.password}
              onChange={(e) => setForm({ ...form, password: e.target.value })}
              className="w-full bg-gray-800 border text-white focus:outline-0 focus:border-amber-300 border-gray-700 rounded-md px-4 py-3"
            />
            <button
              type="submit"
              className="w-full bg-amber-400 text-black px-4 py-3 rounded-md font-medium"
              disabled={loading}
            >
              {loading ? "Creating…" : "Create account"}
            </button>
          </form>
        </div>

        <div className="hidden md:flex flex-col justify-center p-8 rounded-xl bg-gradient-to-br from-yellow-200 to-yellow-600">
          <h3 className="text-2xl font-bold text-gray-900">Join our community</h3>
          <p className="mt-3 text-gray-800">
            Share your ideas, get feedback, and read varied perspectives from
            creators around the world.
          </p>
          <div className="mt-6 text-sm text-gray-900">
            Already have an account?{" "}
            <Link to="/login" className="text-amber-900 hover:underline">
              Sign in
            </Link>
          </div>
        </div>
      </div>
    </main>
  );
}
