import React, { useState } from "react";
import API from "../api";
import { useNavigate, Link } from "react-router-dom";
import { toast } from "react-toastify";

export default function Login() {
  const [form, setForm] = useState({ email: "", password: "" });
  const [loading, setLoading] = useState(false);
  const nav = useNavigate();

  const handle = async (e) => {
    e.preventDefault();
    setLoading(true);
    try {
      const res = await API.post("/auth/login", form);
      localStorage.setItem("token", res.data.token);
      localStorage.setItem("user", JSON.stringify(res.data.user));
      window.dispatchEvent(new Event("userUpdated"));
      nav("/");
    } catch (err) {
      toast.error(err.response?.data?.message || "Login failed");
    } finally {
      setLoading(false);
    }
  };

  return (
    <main className="min-h-[70vh] flex items-center justify-center px-4 py-12">
      <div className="max-w-4xl w-full grid grid-cols-1 md:grid-cols-2 gap-8">
        <div className="hidden md:flex flex-col justify-center bg-gradient-to-br from-yellow-200 to-yellow-600 rounded-xl p-8">
          <h3 className="text-2xl font-bold text-gray-900">Welcome back</h3>
          <p className="mt-3 text-gray-800">
            Log in to create and manage your posts. Discover stories from
            creators worldwide.
          </p>
          <div className="mt-6 text-sm text-gray-900">
            New here?{" "}
            <Link to="/register" className="text-amber-900 hover:underline">
              Create an account
            </Link>
          </div>
        </div>

        <div className="bg-gray-900 rounded-xl p-8 shadow">
          <h2 className="text-xl text-white font-semibold mb-4">Login to your account</h2>
          <form onSubmit={handle} className="space-y-4">
            <input
              required
              type="email"
              placeholder="Email"
              value={form.email}
              onChange={(e) => setForm({ ...form, email: e.target.value })}
              className="w-full bg-gray-800 border text-white focus:outline-0 focus:border-amber-300 border-gray-700 rounded-md px-4 py-3"
            />
            <input
              required
              type="password"
              placeholder="Password"
              value={form.password}
              onChange={(e) => setForm({ ...form, password: e.target.value })}
              className="w-full bg-gray-800 border text-white focus:outline-0 focus:border-amber-300 border-gray-700 rounded-md px-4 py-3"
            />
            <button
              type="submit"
              className="w-full bg-amber-400 text-black px-4 py-3 rounded-md font-medium"
              disabled={loading}
            >
              {loading ? "Signing In…" : "Sign in"}
            </button>
          </form>
        </div>
      </div>
    </main>
  );
}
