import React, { useEffect, useState } from 'react';
import { useParams, Link, useNavigate } from 'react-router-dom';
import API from '../api';

export default function BlogView() {
  const { id } = useParams();
  const nav = useNavigate();
  const [blog, setBlog] = useState(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    let mounted = true;
    API.get(`/blogs/${id}`)
      .then(res => { if (mounted) setBlog(res.data); })
      .catch(err => console.error(err))
      .finally(() => { if (mounted) setLoading(false); });
    return () => (mounted = false);
  }, [id]);

  if (loading) return <div className="max-w-4xl mx-auto p-8 text-gray-400">Loading article…</div>;
  if (!blog) return <div className="max-w-4xl mx-auto p-8 text-gray-400">Article not found.</div>;

  const base = import.meta.env.VITE_API_URL
  ? import.meta.env.VITE_API_URL.replace('/api', '')
  : 'http://localhost:5000';


  return (
    <article className="max-w-4xl mx-auto px-4 py-10">
      <div className="mb-6">
        <button onClick={() => nav(-1)} className="text-sm text-amber-300 hover:underline">← Back</button>
      </div>

      {blog.image && (
        <div className="rounded-xl overflow-hidden mb-6 shadow">
          <img src={base + blog.image} alt={blog.title} className="w-full h-72 object-cover" />
        </div>
      )}

      <header className="mb-6">
        <h1 className="text-3xl sm:text-4xl font-extrabold leading-tight">{blog.title}</h1>
        <div className="mt-2 flex items-center gap-3 text-gray-400">
          <div className="text-sm">by <span className="text-amber-300">{blog.author?.name}</span></div>
          <div className="text-sm">•</div>
          <div className="text-sm">{new Date(blog.createdAt).toLocaleString()}</div>
        </div>
      </header>

      <div className="prose prose-invert max-w-none text-gray-800 whitespace-pre-wrap">
        {blog.content}
      </div>

      <footer className="mt-12 border-t border-gray-800 pt-6 flex items-center justify-between">
        <div className="text-sm text-gray-400">Enjoyed this post? Share it with others.</div>
        <div>
          <Link to="/" className="text-amber-400 font-medium hover:underline">Back to Home</Link>
        </div>
      </footer>
    </article>
  );
}
