import React, { useState } from 'react';
import API from '../api';
import { useNavigate } from 'react-router-dom';
import { toast } from 'react-toastify';

export default function AdminLogin() {
  const [form, setForm] = useState({ email: '', password: '' });
  const navigate = useNavigate();

  const handleSubmit = async (e) => {
    e.preventDefault();
    try {
      const res = await API.post('/admin/login', form);
      localStorage.setItem('token', res.data.token);
      localStorage.setItem('user', JSON.stringify(res.data.admin));
      window.dispatchEvent(new Event('userUpdated'));
      toast.success('Admin logged in successfully!');
      navigate('/admin');
    } catch (err) {
      toast.error(err.response?.data?.message || 'Login failed');
    }
  };

  return (
      <div className="bg-gray-800 p-8 rounded-2xl mx-auto mt-24  shadow-2xl w-full max-w-md">
        <h2 className="text-3xl font-bold text-center text-amber-400 mb-6">Admin Login</h2>
        <form onSubmit={handleSubmit}>
          <input
            type="email"
            required
            placeholder="Admin Email"
            value={form.email}
            onChange={(e) => setForm({ ...form, email: e.target.value })}
            className="w-full p-3 mb-4 bg-gray-700 text-white rounded-lg focus:ring-2 focus:ring-amber-400 outline-none"
          />
          <input
            type="password"
            required
            placeholder="Password"
            value={form.password}
            onChange={(e) => setForm({ ...form, password: e.target.value })}
            className="w-full p-3 mb-6 bg-gray-700 text-white rounded-lg focus:ring-2 focus:ring-amber-400 outline-none"
          />
          <button
            type="submit"
            className="w-full py-3 bg-amber-400 text-black font-semibold rounded-lg hover:bg-amber-500 transition"
          >
            Login
          </button>
        </form>
      </div>
  );
}
