import React from 'react';
import { Link } from 'react-router-dom';

export default function BlogCard({ blog }) {
  const base = import.meta.env.VITE_API_URL
  ? import.meta.env.VITE_API_URL.replace('/api', '')
  : 'http://localhost:5000';

  return (
    <article className="bg-gray-800 rounded-2xl overflow-hidden shadow-lg transform hover:-translate-y-1 transition">
      <Link to={`/blog/${blog._id}`} className="block group">
        <div className="relative h-48 overflow-hidden">
          {blog.image ? (
            <img
              src={base + blog.image}
              alt={blog.title}
              className="w-full h-full object-cover group-hover:scale-105 transform transition duration-500"
            />
          ) : (
            <div className="w-full h-full bg-gradient-to-tr from-gray-700 to-gray-600 flex items-center justify-center">
              <span className="text-gray-300">No image</span>
            </div>
          )}
          <span className="absolute left-3 top-3 bg-amber-400/90 text-black text-xs font-semibold px-2 py-1 rounded-md shadow">
            {blog.author?.name || 'Author'}
          </span>
        </div>

        <div className="p-4">
          <h3 className="text-lg font-semibold text-white truncate">{blog.title}</h3>
          <p className="mt-2 text-sm text-gray-400 line-clamp-3">{blog.summary || blog.content?.slice(0, 120)}</p>
          <div className="mt-4 flex items-center justify-between text-sm">
            <div className="text-gray-300">{new Date(blog.createdAt).toLocaleDateString()}</div>
            <div className="text-amber-300 font-medium">Read →</div>
          </div>
        </div>
      </Link>
    </article>
  );
}
