import React from 'react'
import Translator from './components/Translator'

export default function App() {
  return (
    <div className="min-h-screen flex items-center justify-center p-6">
      <div className="w-full max-w-4xl bg-white rounded-2xl shadow-lg p-6">
        <header className="mb-4">
          <h1 className="text-2xl font-semibold">Language Converter</h1>
          <p className="text-sm text-slate-500">Translate text between languages using the LibreTranslate public API. For production use, deploy your own instance or use a paid provider.</p>
        </header>
        <Translator />
        <footer className="mt-6 text-xs text-slate-500">
          Tip: LibreTranslate has rate-limits. If responses fail, try later or configure a paid API.
        </footer>
      </div>
    </div>
  )
}
