import React from 'react'
import { BarChart, Bar, XAxis, YAxis, Tooltip, ResponsiveContainer } from 'recharts'

export default function Progress({ workouts, meals }) {
  const days = ['Mon','Tue','Wed','Thu','Fri','Sat','Sun']
  // sample aggregator: calories per day from meals' date or distribute
  const data = days.map((d,i)=>({ day:d, calories: Math.floor(Math.random()*400+1500), workouts: Math.round(Math.random()*2) }))
  return (
    <div className="space-y-6">
      <h2 className="text-2xl font-bold">Progress</h2>
      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div className="bg-[color:var(--card)] p-6 rounded-2xl shadow">
          <h3 className="font-semibold mb-4">Calorie Intake</h3>
          <div className="h-64">
            <ResponsiveContainer width="100%" height="100%">
              <BarChart data={data}>
                <XAxis dataKey="day" stroke="#9CA3AF" />
                <YAxis stroke="#9CA3AF" />
                <Tooltip />
                <Bar dataKey="calories" fill="#10B981" radius={[6,6,0,0]} />
              </BarChart>
            </ResponsiveContainer>
          </div>
        </div>
        <div className="bg-[color:var(--card)] p-6 rounded-2xl shadow">
          <h3 className="font-semibold mb-4">Workouts</h3>
          <div className="h-64">
            <ResponsiveContainer width="100%" height="100%">
              <BarChart data={data}>
                <XAxis dataKey="day" stroke="#9CA3AF" />
                <YAxis stroke="#9CA3AF" />
                <Tooltip />
                <Bar dataKey="workouts" fill="#8B5CF6" radius={[6,6,0,0]} />
              </BarChart>
            </ResponsiveContainer>
          </div>
        </div>
      </div>
    </div>
  )
}