import React from 'react'
import { NavLink } from 'react-router-dom'
import { Home, Dumbbell, Utensils, BarChart3, SunMoon, RefreshCcw } from 'lucide-react'

export default function Navbar({ dark, setDark, resetAll }) {
  return (
    <aside className="md:w-64 bg-[color:var(--card)] rounded-2xl p-4 shadow-sm">
      <div className="flex items-center justify-between mb-6">
        <h1 className="text-xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-purple-600 to-blue-600">FitTrack</h1>
        <button onClick={() => setDark(!dark)} title="Toggle theme" className="p-2 rounded-lg hover:bg-gray-100/50">
          <SunMoon />
        </button>
      </div>

      <nav className="flex flex-col gap-2">
        <NavLink to="/" className={({isActive}) => 'flex items-center gap-3 px-3 py-2 rounded-lg ' + (isActive ? 'bg-purple-600 text-white' : 'text-gray-700 hover:bg-gray-100')} end>
          <Home /> Dashboard
        </NavLink>
        <NavLink to="/workouts" className={({isActive}) => 'flex items-center gap-3 px-3 py-2 rounded-lg ' + (isActive ? 'bg-purple-600 text-white' : 'text-gray-700 hover:bg-gray-100')}>
          <Dumbbell /> Workouts
        </NavLink>
        <NavLink to="/meals" className={({isActive}) => 'flex items-center gap-3 px-3 py-2 rounded-lg ' + (isActive ? 'bg-purple-600 text-white' : 'text-gray-700 hover:bg-gray-100')}>
          <Utensils /> Meals
        </NavLink>
        <NavLink to="/progress" className={({isActive}) => 'flex items-center gap-3 px-3 py-2 rounded-lg ' + (isActive ? 'bg-purple-600 text-white' : 'text-gray-700 hover:bg-gray-100')}>
          <BarChart3 /> Progress
        </NavLink>

        <div className="mt-4 border-t pt-4 flex gap-2">
          <button onClick={resetAll} className="flex items-center gap-2 px-3 py-2 rounded-lg bg-red-500 text-white hover:bg-red-600">
            <RefreshCcw /> Reset All
          </button>
        </div>
      </nav>
    </aside>
  )
}