import React, { useState } from 'react'
import Modal from './Modal'
import { saveData } from '../utils/localStorage'

export default function Meals({ meals, setMeals }) {
  const [open, setOpen] = useState(false)
  const [form, setForm] = useState({ name:'', calories:'', time:'' })

  const add = () => {
    if(!form.name || !form.calories) return alert('Enter name + calories')
    const item = { id: Date.now(), ...form, calories: Number(form.calories) }
    const next = [item, ...meals]
    setMeals(next)
    saveData('meals', next)
    setForm({ name:'', calories:'', time:'' })
    setOpen(false)
  }

  const del = (id) => {
    const next = meals.filter(m=>m.id!==id)
    setMeals(next)
    saveData('meals', next)
  }

  return (
    <div className="space-y-4">
      <div className="flex justify-between items-center">
        <h2 className="text-2xl font-bold">Meals</h2>
        <button onClick={()=>setOpen(true)} className="bg-green-600 text-white px-4 py-2 rounded-lg">+ Add</button>
      </div>

      {meals.length===0 ? <p className="text-gray-500">No meals added.</p> : (
        <ul className="space-y-3">
          {meals.map(m => (
            <li key={m.id} className="bg-[color:var(--card)] p-4 rounded-xl flex justify-between items-center shadow">
              <div>
                <div className="font-medium">{m.name}</div>
                <div className="text-sm text-gray-500">{m.calories} cal</div>
              </div>
              <div className="flex items-center gap-2">
                <div className="text-sm text-gray-500">{m.time||''}</div>
                <button onClick={()=>del(m.id)} className="text-red-500">✕</button>
              </div>
            </li>
          ))}
        </ul>
      )}

      {open && (
        <Modal title="Add Meal" onClose={()=>setOpen(false)}>
          <div className="flex flex-col gap-3">
            <input value={form.name} onChange={e=>setForm({...form,name:e.target.value})} placeholder="Meal name" className="border p-2 rounded" />
            <input value={form.calories} onChange={e=>setForm({...form,calories:e.target.value})} placeholder="Calories" type="number" className="border p-2 rounded" />
            <input value={form.time} onChange={e=>setForm({...form,time:e.target.value})} type="time" className="border p-2 rounded" />
            <button onClick={add} className="bg-green-600 text-white py-2 rounded">Add</button>
          </div>
        </Modal>
      )}
    </div>
  )
}