import React from "react";
import { Dumbbell, Flame, Clock } from "lucide-react";

export default function Dashboard({ workouts, meals }) {
  const totalWorkouts = workouts.length;
  const totalCalories = meals.reduce((s, m) => s + (m.calories || 0), 0);
  const totalMinutes = workouts.reduce((s, w) => s + (w.duration || 0), 0);

  return (
    <div className="space-y-6">
      <h2 className="text-2xl font-bold">Dashboard</h2>
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div className="bg-card rounded-2xl p-6 shadow transition-colors">
          <div className="flex items-center gap-4">
            <Dumbbell className="text-purple-500" />
            <div>
              <div className="text-sm text-muted">Workouts</div>
              <div className="text-2xl font-semibold">{totalWorkouts}</div>
            </div>
          </div>
        </div>

        <div className="bg-[color:var(--card)] rounded-2xl p-6 shadow">
          <div className="flex items-center gap-4">
            <Flame className="text-red-500" />
            <div>
              <div className="text-sm text-gray-500">Calories</div>
              <div className="text-2xl font-semibold">{totalCalories}</div>
            </div>
          </div>
        </div>
        <div className="bg-[color:var(--card)] rounded-2xl p-6 shadow">
          <div className="flex items-center gap-4">
            <Clock className="text-green-500" />
            <div>
              <div className="text-sm text-gray-500">Minutes</div>
              <div className="text-2xl font-semibold">{totalMinutes}</div>
            </div>
          </div>
        </div>
      </div>

      <section className="bg-[color:var(--card)] rounded-2xl p-6 shadow">
        <h3 className="font-semibold mb-2">Recent Workouts</h3>
        {workouts.length === 0 ? (
          <p className="text-gray-500">No workouts yet.</p>
        ) : (
          <ul className="space-y-2">
            {workouts.slice(0, 5).map((w) => (
              <li key={w.id} className="flex justify-between items-center">
                <div>
                  <div className="font-medium">{w.name}</div>
                  <div className="text-sm text-gray-500">{w.duration} min</div>
                </div>
                <div className="text-sm text-gray-500">{w.date || ""}</div>
              </li>
            ))}
          </ul>
        )}
      </section>
    </div>
  );
}
