import streamlit as st
from groq import Groq

# Initialize Groq client
client = Groq(api_key="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")

# Streamlit Page Config
st.set_page_config(page_title="AI Email Generator", page_icon="")
st.title("AI Email Generator (Free with Groq)")
st.write("Generate professional emails instantly using the free Llama 3 model via Groq API!")

# Input box
prompt = st.text_area(" Describe your email:", placeholder="e.g., Thank the interviewer for their time and opportunity")

# Dropdown for tone
tone = st.selectbox(" Choose a tone:", ["Formal", "Friendly", "Apologetic", "Persuasive", "Thankful"])

length = st.radio(" Choose email length:", ["Short", "Medium", "Detailed"])

if st.button("Generate Email "):
    if prompt.strip():
        with st.spinner("Thinking... generating your email..."):
            full_prompt = f"Write a {length.lower()} {tone.lower()} email about: {prompt}. Include a subject line and proper sign-off."
            
            chat_completion = client.chat.completions.create(
                model="llama-3.1-8b-instant",
                messages=[{"role": "user", "content": full_prompt}],
                temperature=0.7,
            )
            
            email_text = chat_completion.choices[0].message.content
            
            st.success(" Email Generated Successfully!")
            st.text_area("Your Generated Email:", email_text, height=300)
            
            # Download button
            st.download_button(
                label=" Download Email as TXT",
                data=email_text,
                file_name="generated_email.txt"
            )
    else:
        st.warning(" Please enter a description for your email before generating.")

# Footer
st.markdown("---")
