// main.js - TravelVista final
document.addEventListener('DOMContentLoaded', function(){
  const current = location.pathname.split('/').pop() || 'index.html';
  document.querySelectorAll('.nav-link').forEach(link => {
    if(link.getAttribute('href') === current) link.classList.add('active');
  });

  const contactForm = document.getElementById('contactForm');
  if(contactForm){
    contactForm.addEventListener('submit', function(e){
      e.preventDefault();
      const name = document.getElementById('name').value || 'Traveler';
      alert('Thanks ' + name + '! We received your message and will respond within 24 hours.');
      contactForm.reset();
    });
  }
});
