import React, { useState } from "react";
import axios from "axios";

const API_URL = "http://localhost:5000/api/todos";

export default function TodoForm({ onAdd }) {
  const [title, setTitle] = useState("");

  const handleSubmit = async (e) => {
    e.preventDefault();
    if (!title.trim()) return;
    await axios.post(API_URL, { title });
    setTitle("");
    onAdd();
  };

  return (
    <form
      onSubmit={handleSubmit}
      className="flex gap-3 bg-white/80 backdrop-blur-md border border-blue-100 shadow-sm rounded-md px-4 py-3 transition-all duration-300 hover:shadow-md"
    >
      <input
        type="text"
        value={title}
        onChange={(e) => setTitle(e.target.value)}
        placeholder="Add a new task..."
        className="flex-1 px-4 py-2 bg-transparent outline-none text-gray-800 placeholder-gray-400 text-base rounded-lg focus:ring-2 focus:ring-blue-500 focus:bg-blue-50/30 transition-all duration-300"
      />
      <button
        type="submit"
        className="px-8 py-2 border border-blue-100 text-blue-600 font-medium rounded-full hover:bg-blue-600 hover:text-white"
      >
        Add
      </button>
    </form>
  );
}
