from django.contrib import admin
from django.urls import path,include
from app_modules.userapp import views

urlpatterns = [
    path("", views.demo_view, name="demo"),
    path("register/", views.register_view, name="register"),
    path("login/", views.login_view, name="login"),
    path("logout/", views.logout_view, name="logout"),
    
    path('resume_create/', views.resume_create, name='resume_create'),
    path('resume_list/', views.resume_list, name='resume_list'),
    path('resume_detail/<int:id>/', views.resume_detail, name='resume_detail'),
    path('resume_edit/<int:id>/', views.resume_edit, name='resume_edit'),
    path('resume_delete/<int:id>/', views.resume_delete, name='resume_delete'),
    path('resume_download/<int:id>/', views.resume_download, name='resume_download'),
    path("resume_preview/<int:resume_id>/", views.resume_preview, name="resume_preview"),

]   