from django.db import models

from django.db import models
from django.contrib.auth.models import User


# Main Resume Model
class Resume(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE, related_name="resumes")
    title = models.CharField(max_length=255, default="My Resume")
    summary = models.TextField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    template_choice = models.CharField(
        max_length=50,
        choices=[
            ('template1', 'Template 1'),
            ('template2', 'Template 2'),
            ('template3', 'Template 3'),
        ],
        default='template1'
    )

    def __str__(self):
        return f"{self.title} ({self.user.username})"


# Personal Information
class PersonalInfo(models.Model):
    resume = models.OneToOneField(Resume, on_delete=models.CASCADE, related_name="personal_info")
    full_name = models.CharField(max_length=200)
    email = models.EmailField()
    phone = models.CharField(max_length=20)
    address = models.CharField(max_length=255, blank=True, null=True)
    linkedin = models.URLField(blank=True, null=True)
    github = models.URLField(blank=True, null=True)
    portfolio = models.URLField(blank=True, null=True)
    dob = models.DateField(blank=True, null=True)
    nationality = models.CharField(max_length=50, blank=True, null=True)

    def __str__(self):
        return self.full_name


# Education
class Education(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="education")
    degree = models.CharField(max_length=200)
    institution = models.CharField(max_length=200)
    location = models.CharField(max_length=100, blank=True, null=True)
    start_year = models.PositiveIntegerField()
    end_year = models.PositiveIntegerField(blank=True, null=True)
    grade = models.CharField(max_length=50, blank=True, null=True)

    def __str__(self):
        return f"{self.degree} - {self.institution}"


# Work Experience
class Experience(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="experience")
    job_title = models.CharField(max_length=200)
    company = models.CharField(max_length=200)
    location = models.CharField(max_length=100, blank=True, null=True)
    start_date = models.DateField()
    end_date = models.DateField(blank=True, null=True)
    responsibilities = models.TextField()

    def __str__(self):
        return f"{self.job_title} at {self.company}"


# Projects
class Project(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="projects")
    title = models.CharField(max_length=200)
    organization = models.CharField(max_length=200, blank=True, null=True)
    duration = models.CharField(max_length=100, blank=True, null=True)
    description = models.TextField()
    technologies = models.CharField(max_length=300, blank=True, null=True)

    def __str__(self):
        return self.title


# Skills
class Skill(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="skills")
    category = models.CharField(
        max_length=100,
        choices=[("technical", "Technical"), ("soft", "Soft Skill"), ("language", "Language")]
    )
    name = models.CharField(max_length=100)

    def __str__(self):
        return f"{self.category} - {self.name}"


# Certifications
class Certification(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="certifications")
    name = models.CharField(max_length=200)
    issued_by = models.CharField(max_length=200)
    year = models.PositiveIntegerField()

    def __str__(self):
        return self.name


# Achievements
class Achievement(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="achievements")
    title = models.CharField(max_length=255)
    description = models.TextField(blank=True, null=True)

    def __str__(self):
        return self.title


# Extracurricular Activities
class Extracurricular(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="extracurricular")
    activity = models.CharField(max_length=200)
    description = models.TextField(blank=True, null=True)

    def __str__(self):
        return self.activity


# References (Optional)
class Reference(models.Model):
    resume = models.ForeignKey(Resume, on_delete=models.CASCADE, related_name="references")
    name = models.CharField(max_length=200)
    designation = models.CharField(max_length=200)
    company = models.CharField(max_length=200)
    contact = models.CharField(max_length=100, blank=True, null=True)

    def __str__(self):
        return self.name



