from django import forms
from .models import Resume, PersonalInfo, Education, Experience, Project, Skill

class ResumeForm(forms.ModelForm):
    class Meta:
        model = Resume
        fields = ['title', 'summary', 'template_choice']
        widgets = {'template_choice': forms.RadioSelect,}

class PersonalInfoForm(forms.ModelForm):
    class Meta:
        model = PersonalInfo
        exclude = ["resume"]

class EducationForm(forms.ModelForm):
    class Meta:
        model = Education
        exclude = ["resume"]

class ExperienceForm(forms.ModelForm):
    class Meta:
        model = Experience
        exclude = ["resume"]

class ProjectForm(forms.ModelForm):
    class Meta:
        model = Project
        exclude = ["resume"]

class SkillForm(forms.ModelForm):
    class Meta:
        model = Skill
        exclude = ["resume"]
