from django.contrib import admin
from . import models

def make_admin(model):
    class CustomAdmin(admin.ModelAdmin):
        list_display = [field.name for field in model._meta.fields]
        list_filter = [field.name for field in model._meta.fields if field.get_internal_type() in ["BooleanField", "DateField", "DateTimeField", "IntegerField", "ForeignKey"]]
        search_fields = [field.name for field in model._meta.fields if field.get_internal_type() in ["CharField", "TextField"]]
    return CustomAdmin

# Register each model with auto-generated admin
admin.site.register(models.Resume, make_admin(models.Resume))
admin.site.register(models.PersonalInfo, make_admin(models.PersonalInfo))
admin.site.register(models.Education, make_admin(models.Education))
admin.site.register(models.Experience, make_admin(models.Experience))
admin.site.register(models.Project, make_admin(models.Project))
admin.site.register(models.Skill, make_admin(models.Skill))
admin.site.register(models.Certification, make_admin(models.Certification))
admin.site.register(models.Achievement, make_admin(models.Achievement))
admin.site.register(models.Extracurricular, make_admin(models.Extracurricular))
admin.site.register(models.Reference, make_admin(models.Reference))
